% acoustics.cls
% 	Acoustics Conference LaTeX class
% 	11 Aug. 2012
% 	Authors: 	Konstantinos Drossos
%			Andreas Floros
% 	
% 			For inquiries please email at
% 			kdrosos@ionio.gr
%				or
%			floros@ionio.gr


% --- Class structure: Identification part
% ---
\ProvidesClass{acoustics}[2012/08/12 version 1.0 Acoustics Conference Class]
\NeedsTeXFormat{LaTeX2e}

% --- Class structure: Declaration of options
% ---
% Acoustics.sty extends the article class
% No article class options are valid
\LoadClass[pdftex,10pt, a4paper]{article}

% --- Page layout
% ---
\RequirePackage[	a4paper,%		A4 paper size
		  		left=4.5 cm,%		Left margin size
		  		right=4.5 cm,%		Right margin size 
		  		top=4.9 cm,%		Top margin size
		  		bottom=4.9 cm,%	Bottom margin size
		  		headsep = 5pt]%	Separation of headers and footers size
				{geometry}
		
% --- Fonts and languages		
\RequirePackage[	english,%
				greek]%
				{babel}
				
\RequirePackage[	iso-8859-7]%
				{inputenc}
\RequirePackage[	LGR,%
				T1]%
				{fontenc}       
\fontfamily{tmr}
\newcommand{\en}{\latintext}
\newcommand{\el}{\greektext}

% --- Bibliography
% ---

% --- Equations and Maths
% ---
\RequirePackage{amsmath}
\RequirePackage{amsthm}
\RequirePackage{amssymb}

% --- Symbols relates
% ---
\RequirePackage{ascii}

% --- Titles, captions, sectioning and numbering
% ---
\RequirePackage{titlesec}
\setlength{\parindent}{0.5cm}

\titleformat{\section}
{\bfseries\fontsize{11pt}{11pt}\selectfont}{\thesection}{1em}{}
\titlespacing*{name=\section,numberless}{0pt}{11pt}{12pt}
\titlespacing*{\section}{\parindent}{11pt}{12pt}

\titleformat{\subsection}
{\normalfont\em\fontsize{10}{10}}{\thesubsection}{1em}{}
\titlespacing*{\subsection}
{\parindent}{10pt}{10pt}
\numberwithin{table}{section}

\RequirePackage{caption}
\captionsetup{margin=8pt,
			font=normalsize,
			labelfont=normalfont,
			labelsep=quad,
			justification=centering,
			textfont = it}						
\renewcommand{\thefigure}{\arabic{section}.\arabic{figure}}
\numberwithin{table}{section}
\numberwithin{figure}{section}
\RequirePackage{enumitem}

% --- Graphics and images related
% ---
\RequirePackage{graphicx}

% --- Headers
% ---
\RequirePackage{fancyhdr}
\pagestyle{fancy}

\newcommand{\defpaperId}[1]{
  \def\paperId{#1}
 }
\newcommand{\defconfYear}[2]{
  \def\confYear{#1}
  \def\confShortYear{#2}
}

\fancyhead{}
\fancyhead[L]%
{\textit{\el  \confYear}}

\fancyhead[R]
{\greektext{\textit{\el AK\confShortYear\_\paperId}}}

\fancyfoot{}
\fancyfoot[L]
{}
\fancyfoot[R]
{}
\fancyfoot[C]
{}

\renewcommand{\headrulewidth}{0pt}

% --- Title page
% ---
\makeatletter

\def\@maketitle{%
  \newpage%
  \null%
  \vskip 2em%
  \begin{center}%
  \let \footnote \thanks
    {\vspace{12pt}\fontsize{14pt}{14pt}\selectfont\textbf \@title \par}%
    \vskip 12pt%
    {\large%
      \lineskip 12pt%
      \fontsize{10pt}{10pt}\selectfont
      \begin{tabular}[t]{c}%
        \@author
      \end{tabular}\par}%
  \end{center}%
  \par}

\makeatother

\makeatletter
% Copied from article.cls
\renewcommand\maketitle{\par
  \begingroup
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
    \long\def\@makefntext##1{\parindent 1em\noindent
            \hb@xt@1.8em{%
                \hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
    \if@twocolumn
      \ifnum \col@number=\@ne
        \@maketitle
      \else
        \twocolumn[\@maketitle]%
      \fi
    \else
      \newpage
      \global\@topnum\z@   % Prevents figures from going at top of page.
      \@maketitle
    \fi
    \thispagestyle{fancy}\@thanks % was {empty}
  \endgroup
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
}
% end of copy
\makeatother

% The abstracts environments
\newenvironment{abstractGreek}%
{%
\textbf%
{%
\begin{center}%
\fontsize{12pt}{12pt}\selectfont\greektext{{\textbf{}}}%
\end{center}%
}%
\vspace{5pt}\begin{itshape}\fontsize{10pt}{10pt}%
}%
{\vspace{10pt}\end{itshape}}

\newenvironment{abstractEnglish}%
{\textbf{%
\vspace{-15pt}
\begin{center}%
\fontsize{12pt}{12pt}\selectfont \latintext{ABSTRACT}%
\end{center}%
}%
\en\vspace{-5pt}\begin{itshape}\fontsize{10pt}{10pt}\vspace{6pt}\par
}%
{\vspace{1pt}\end{itshape}}%  


\newenvironment{titleSecondary}%
{%
{}\en\bfseries\centering\begin{center}\fontsize{14pt}{14pt}\selectfont%
}%
{\end{center}\vspace{-2pt}}

\makeatletter
\let\@afterindentfalse\@afterindenttrue
\makeatother

\makeatletter
\renewenvironment{thebibliography}[1]
     {\section*{\refname}%
      \@mkboth{\MakeUppercase\refname}{\MakeUppercase\refname}%
      \list{\@biblabel{\@arabic\c@enumiv}}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin-0.5cm% change 20 pt according to your needs
            \advance\leftmargin\labelsep
            \setlength\itemindent{1cm}% change using the inverse of the length used before
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \sloppy
      \clubpenalty4000
      \@clubpenalty \clubpenalty
      \widowpenalty4000%
      \sfcode`\.\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}
\renewcommand\newblock{\hskip .11em\@plus.33em\@minus.07em}
\makeatother

\RequirePackage{etoolbox}
\patchcmd{\thebibliography}{\section*}{\section}{}{}